# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_SPANISH} "(Use el CD)"
LangString ReadOnly ${LANG_SPANISH} "(Slo lectura)"
LangString MainHeaderSubText ${LANG_SPANISH} "Seleccione un nombre de usuario y una contrasea para la nueva cuenta"
LangString MainLanguageLabel ${LANG_SPANISH} "Idioma:"
LangString MainUsernameLabel ${LANG_SPANISH} "Usuario:"
LangString MainPasswordLabel ${LANG_SPANISH} "Contrasea:"
LangString MainInstallationSizeLabel ${LANG_SPANISH} "Tamao de la instalacin (GB):"
LangString MainDistroLabel ${LANG_SPANISH} "Entorno de escritorio:"
LangString MainInstallationDriveLabel ${LANG_SPANISH} "Unidad para la instalacin ($freeSpace GB libres):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_SPANISH} "Idioma de la instalacin"
LangString MainUsernameToolTip ${LANG_SPANISH} "Por favor seleccione un nombre de usuario para la nueva cuenta.$\r$\nSolo en letras minsculas.$\r$\nNo debe contener espacios.$\r$\nDebe contener solamente letras y nmeros estndar.$\r$\nNo puede empezar con un nmero."
LangString MainPasswordToolTip ${LANG_SPANISH} "Por favor seleccione una contrasea para la nueva cuenta de usuario.$\r$\nNo debe contener espacios."
LangString MainInstallationSizeToolTip ${LANG_SPANISH} "Cuntos GB quiere asignar?$\r$\n4GB es lo mnimo indispensable$\r$\n8GB es lo recomendable"
LangString MainInstallationDriveToolTip ${LANG_SPANISH} "En qu unidad quiere realizar la instalacin?$\r$\nEsta unidad debera tener al menos 5 Gb libres."
LangString Distro1ToolTip ${LANG_SPANISH} "Ubuntu es la opcin predeterminada."
LangString Distro2ToolTip ${LANG_SPANISH} "Kubuntu usa el escritorio KDE3.5."
LangString Distro3ToolTip ${LANG_SPANISH} "Kubuntu-KDE4 usa el escritorio KDE4."
LangString Distro4ToolTip ${LANG_SPANISH} "Xubuntu es apropiado para los sistemas ms antiguos."
LangString MainDistroToolTip ${LANG_SPANISH} "Qu entorno grfico desea instalar?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_SPANISH} "Por favor, introduzca un nombre de usuario vlido."
LangString ErrorSpaceInUsername ${LANG_SPANISH} "Por favor, no use espacios en el nombre de usuario."
LangString ErrorUsernameUpperCase ${LANG_SPANISH} "Por favor, use solo minsculas en el nombre de usuario."
LangString ErrorUsernameFirstCharNotLetter ${LANG_SPANISH} "Su nombre de usuario debe empezar con una letra."
LangString ErrorUsernameIllegalChars ${LANG_SPANISH} "Su nombre de usuario debe contener nicamente letras y nmeros estndar."
LangString ErrorReservedUsername ${LANG_SPANISH} "El nombre de usuario seleccionado est reservado. Por favor seleccione uno diferente."
LangString ErrorNoPassword ${LANG_SPANISH} "Por favor, introduzca una contrasea vlida."
LangString ErrorPasswordMismatch ${LANG_SPANISH} "Las contraseas no coinciden."
LangString ErrorSpaceInPassword ${LANG_SPANISH} "Por favor, no use espacios en la contrasea."
LangString ErrorNoFreeSpace ${LANG_SPANISH} "No hay espacio libre suficiente."
LangString ErrorNoKernel ${LANG_SPANISH} "No se pudieron recuperar algunos archivos esenciales."
LangString ErrorBcdedit ${LANG_SPANISH} "Error intentando ejecutar bcdedit:"
LangString ErrorWubibcd ${LANG_SPANISH} "Error intentando ejecutar wubibcd:"
LangString ErrorCD2ISO ${LANG_SPANISH} "No se pudo acceder al CD. Por favor, asegrese de que otras aplicaciones no lo estn usando y pruebe de nuevo."
LangString ErrorDownload ${LANG_SPANISH} "La descarga fue interrumpida con el error:"
LangString ErrorNoCD ${LANG_SPANISH} "No se pudo localizar ningn CD apropiado"
LangString ErrorNoAdmin ${LANG_SPANISH} "Debe iniciar sesin como administrador!"
LangString ErrorNoMemory ${LANG_SPANISH} "Necesita como mnimo ${MinMemoryMB}MB de memoria para ejecutar el instalador."

# INSTALLER
LangString AboutToInstall ${LANG_SPANISH} "Est a punto de instalar $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_SPANISH} "Instalando $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_SPANISH} "Por favor, espere mientras se recuperan y preparan los archivos requeridos"
LangString InstallHeaderUncompressWubifolder ${LANG_SPANISH} "Descomprimiendo la carpeta de wubi..."
LangString InstallHeaderCopyIso ${LANG_SPANISH} "Copiando archivos de instalacin..."
LangString InstallHeaderDownload ${LANG_SPANISH} "Recuperando los archivos de instalacin, se permite la reanudacin posterior"
LangString InstallHeaderBackupIso ${LANG_SPANISH} "Haciendo copia de seguridad de los archivos de instalacin..."
LangString InstallHeaderWritePreseed ${LANG_SPANISH} "Escribiendo los archivos de configuracin..."
LangString InstallHeaderWriteUninstaller ${LANG_SPANISH} "Configurando el desinstalador..."
LangString InstallHeaderWriteBootLoader ${LANG_SPANISH} "Configurando el cargador de arranque..."
LangString InstallGenerateVirtualDisks ${LANG_SPANISH} "Creando discos virtuales..."
LangString InstallCopyFiles ${LANG_SPANISH} "Copiando archivos de instalacin..."
LangString InstallCreateFolders ${LANG_SPANISH} "Creando carpetas..."
LangString InstallRetrieveIso ${LANG_SPANISH} "Recuperando los archivos de instalacin."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_SPANISH} "${AppName} ya est instalado"
LangString UninstallAsk ${LANG_SPANISH} "Desea desinstalarlo?"
LangString UninstallMessageField ${LANG_SPANISH} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_SPANISH} "Hacer una copia de los archivos descargados (archivo de CD ISO)."
LangString UninstallBackupHomeCheckBox ${LANG_SPANISH} "Haga una copia de los documentos personales (home.disk)"
LangString UninstallBackupLocationField ${LANG_SPANISH} "Ubicacin de la copia de seguridad: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_SPANISH} "Por favor, retire cualquier CD/DVD y reinicie para completar la instalacin."
LangString RebootMsg ${LANG_SPANISH} "Debe reiniciar para completar la instalacin."

# DOWNLOADER
LangString MetadlDownloading ${LANG_SPANISH} "Descargando los archivos de instalacin..."
LangString MetadlChecking ${LANG_SPANISH} "Revisando los archivos de instalacin..."
LangString MetadlConnecting ${LANG_SPANISH} "Conectando a %s..."
LangString MetadlInitializing ${LANG_SPANISH} "Inicializando..."
LangString MetadlChecksums ${LANG_SPANISH} "Calculando sumas de comprobacin..."
LangString MetadlRetrying1 ${LANG_SPANISH} "Reintentando en %d segundos... (%d de %d)"
LangString MetadlRetrying2 ${LANG_SPANISH} "Reintentando en %d segundos..."
LangString MetadlSecond ${LANG_SPANISH} "segundo"
LangString MetadlSeconds ${LANG_SPANISH} "segundos"
LangString MetadlProgress ${LANG_SPANISH} "%s (%d%%) de %s a %s/s"
LangString MetadlRemaining ${LANG_SPANISH} " (%s restantes)"
LangString PleaseConnect ${LANG_SPANISH} "Por favor, conctese a Internet ahora."

# ACCESSIBILITY
LangString MobilityAids ${LANG_SPANISH} "Ayudas de movilidad"
LangString VisibilityAids ${LANG_SPANISH} "Ayudas de visibilidad"
LangString AccessibilityButton ${LANG_SPANISH} "Accesibilidad"
LangString AccessibilityText ${LANG_SPANISH} "Perfil de accesibilidad"
LangString AccessibilitySubText ${LANG_SPANISH} "Por favor, seleccione el perfil de accesibilidad apropiado"
LangString NoAccessibility ${LANG_SPANISH} "Ninguno"
LangString VisibilityHighContrast ${LANG_SPANISH} "Alto contraste"
LangString VisibilityMagnifier ${LANG_SPANISH} "Ampliador"
LangString VisibilityScreenReader ${LANG_SPANISH} "Lector de pantalla"
LangString VisibilityBraille ${LANG_SPANISH} "Terminal Braille"
LangString MobilityKeyboardModifiers ${LANG_SPANISH} "Modificadores de teclado"
LangString MobilityOnScreenKeyboard ${LANG_SPANISH} "Teclado en pantalla"

# CDBOOT
LangString CDBootTitle ${LANG_SPANISH} "Instalar el cargador del CD"
LangString CDBootText ${LANG_SPANISH} "Si su equipo no puede arrancar desde el CD, este programa instalar una nueva entrada en el men de arranque para ayudarle a arrancar desde el CD. En la mayora de los casos este programa no es necesario, y basta con reiniciar el equipo con el CD-ROM dentro de la unidad.$\r$\n$\r$\nQuiere continuar e instalar el cargador del CD?"

# BOOTMENU
LangString BootMenuNormal ${LANG_SPANISH} "Iniciar el instalador en modo normal"
LangString BootMenuSafeGraphics ${LANG_SPANISH} "Iniciar el instalador en modo grfico seguro (solo si Ud. tiene problemas de pantalla)"
LangString BootMenuACPI ${LANG_SPANISH} "Iniciar el instalador con soluciones provisorias de ACPI (solo si Ud. tiene problemas de ACPI)"
LangString BootMenuVerbose ${LANG_SPANISH} "Iniciar el instalador en modo detallado"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_SPANISH} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
