# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_ALBANIAN} "(Use CD)"
LangString ReadOnly ${LANG_ALBANIAN} "(Read Only)"
LangString MainHeaderSubText ${LANG_ALBANIAN} "Please select username and password for the new account"
LangString MainLanguageLabel ${LANG_ALBANIAN} "Language:"
LangString MainUsernameLabel ${LANG_ALBANIAN} "Username:"
LangString MainPasswordLabel ${LANG_ALBANIAN} "Password:"
LangString MainInstallationSizeLabel ${LANG_ALBANIAN} "Installation Size (GB):"
LangString MainDistroLabel ${LANG_ALBANIAN} "Desktop Environment:"
LangString MainInstallationDriveLabel ${LANG_ALBANIAN} "Installation Drive ($freeSpace GB free):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_ALBANIAN} "Installation language."
LangString MainUsernameToolTip ${LANG_ALBANIAN} "Please select a username for the new account.$\r$\nIt must be lower case.$\r$\nIt must not contain spaces.$\r$\nIt must contain only standard letters and numbers.$\r$\nIt cannot start by a number."
LangString MainPasswordToolTip ${LANG_ALBANIAN} "Please select a password for the new account.$\r$\nIt must not contain spaces."
LangString MainInstallationSizeToolTip ${LANG_ALBANIAN} "How many GB do you want to allocate?$\r$\n4GB is the bare minimum$\r$\n8GB is comfortable"
LangString MainInstallationDriveToolTip ${LANG_ALBANIAN} "In which drive do you want to perform the installation?$\r$\nThis drive should have at least 5 GB free."
LangString Distro1ToolTip ${LANG_ALBANIAN} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_ALBANIAN} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_ALBANIAN} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_ALBANIAN} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_ALBANIAN} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_ALBANIAN} "Please enter a valid username"
LangString ErrorSpaceInUsername ${LANG_ALBANIAN} "Please do not use spaces in the username."
LangString ErrorUsernameUpperCase ${LANG_ALBANIAN} "Please use all lower cases in the username."
LangString ErrorUsernameFirstCharNotLetter ${LANG_ALBANIAN} "Your username must start with a letter."
LangString ErrorUsernameIllegalChars ${LANG_ALBANIAN} "Your username must contain only standard letters and numbers."
LangString ErrorReservedUsername ${LANG_ALBANIAN} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_ALBANIAN} "Please enter a valid password."
LangString ErrorPasswordMismatch ${LANG_ALBANIAN} "Passwords do not match."
LangString ErrorSpaceInPassword ${LANG_ALBANIAN} "Please do not use spaces in the password."
LangString ErrorNoFreeSpace ${LANG_ALBANIAN} "Not enough free space."
LangString ErrorNoKernel ${LANG_ALBANIAN} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_ALBANIAN} "Error while trying to execute bcdedit:"
LangString ErrorWubibcd ${LANG_ALBANIAN} "Error while trying to execute wubibcd:"
LangString ErrorCD2ISO ${LANG_ALBANIAN} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_ALBANIAN} "The download was interrupted with the error:"
LangString ErrorNoCD ${LANG_ALBANIAN} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_ALBANIAN} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_ALBANIAN} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_ALBANIAN} "You are about to install $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_ALBANIAN} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_ALBANIAN} "Please wait while the required files are retrieved and prepared"
LangString InstallHeaderUncompressWubifolder ${LANG_ALBANIAN} "Uncompressing wubi folder..."
LangString InstallHeaderCopyIso ${LANG_ALBANIAN} "Copying installation files..."
LangString InstallHeaderDownload ${LANG_ALBANIAN} "Retrieving installation files, resume supported"
LangString InstallHeaderBackupIso ${LANG_ALBANIAN} "Backing up installation files..."
LangString InstallHeaderWritePreseed ${LANG_ALBANIAN} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_ALBANIAN} "Setting up uninstaller..."
LangString InstallHeaderWriteBootLoader ${LANG_ALBANIAN} "Setting up bootloader..."
LangString InstallGenerateVirtualDisks ${LANG_ALBANIAN} "Creating virtual disks..."
LangString InstallCopyFiles ${LANG_ALBANIAN} "Copying installation files..."
LangString InstallCreateFolders ${LANG_ALBANIAN} "Creating folders..."
LangString InstallRetrieveIso ${LANG_ALBANIAN} "Retrieving installation files."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_ALBANIAN} "${AppName} is already installed"
LangString UninstallAsk ${LANG_ALBANIAN} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_ALBANIAN} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_ALBANIAN} "Backup downloaded files (CD ISO file)."
LangString UninstallBackupHomeCheckBox ${LANG_ALBANIAN} "Backup personal documents (home.disk)."
LangString UninstallBackupLocationField ${LANG_ALBANIAN} "Backup location: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_ALBANIAN} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_ALBANIAN} "You need to reboot to complete the installation."

# DOWNLOADER
LangString MetadlDownloading ${LANG_ALBANIAN} "Downloading installation files..."
LangString MetadlChecking ${LANG_ALBANIAN} "Checking installation files..."
LangString MetadlConnecting ${LANG_ALBANIAN} "Connecting to %s..."
LangString MetadlInitializing ${LANG_ALBANIAN} "Initializing..."
LangString MetadlChecksums ${LANG_ALBANIAN} "Calculating checksums..."
LangString MetadlRetrying1 ${LANG_ALBANIAN} "Retrying in %d seconds... (%d of %d)"
LangString MetadlRetrying2 ${LANG_ALBANIAN} "Retrying in %d seconds..."
LangString MetadlSecond ${LANG_ALBANIAN} "second"
LangString MetadlSeconds ${LANG_ALBANIAN} "seconds"
LangString MetadlProgress ${LANG_ALBANIAN} "%s (%d%%) of %s @ %s/s"
LangString MetadlRemaining ${LANG_ALBANIAN} " (%s remaining)"
LangString PleaseConnect ${LANG_ALBANIAN} "Please connect to the internet now."

# ACCESSIBILITY
LangString MobilityAids ${LANG_ALBANIAN} "Mobility Aids"
LangString VisibilityAids ${LANG_ALBANIAN} "Visibility Aids"
LangString AccessibilityButton ${LANG_ALBANIAN} "&Accessibility"
LangString AccessibilityText ${LANG_ALBANIAN} "Accessibility profile"
LangString AccessibilitySubText ${LANG_ALBANIAN} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_ALBANIAN} "None"
LangString VisibilityHighContrast ${LANG_ALBANIAN} "High Contrast"
LangString VisibilityMagnifier ${LANG_ALBANIAN} "Magnifier"
LangString VisibilityScreenReader ${LANG_ALBANIAN} "Screen Reader"
LangString VisibilityBraille ${LANG_ALBANIAN} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_ALBANIAN} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_ALBANIAN} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_ALBANIAN} "Install CD booter"
LangString CDBootText ${LANG_ALBANIAN} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_ALBANIAN} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_ALBANIAN} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_ALBANIAN} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_ALBANIAN} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_ALBANIAN} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
