/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bookmarksHome.
 *
 * The Initial Developer of the Original Code is
 * Jeroen Groenenboom <jagrboom@zonnet.nl>
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function lifemarkData(title, URL)
{
	this.title = title;
	this.URL = URL;
}
var liveBookmarks = 
{
	// RDF namespaces
	NC_NS : "http://home.netscape.com/NC-rdf#",
	RDF_NS : "http://www.w3.org/1999/02/22-rdf-syntax-ns#",

	getRDF: function()
	{
		return Components.classes["@mozilla.org/rdf/rdf-service;1"]
			.getService( Components.interfaces.nsIRDFService );
	},

	getRDFC: function()
	{
		return Components.classes["@mozilla.org/rdf/container;1"]
			.createInstance( Components.interfaces.nsIRDFContainer );
	},

	getRDFCU: function()
	{
		return Components.classes["@mozilla.org/rdf/container-utils;1"]
			.getService( Components.interfaces.nsIRDFContainerUtils );
	},

	getProperty: function ( aInput, aArc, DS )
	{
		var node;
		node = DS.GetTarget( aInput, aArc, true );
		if( node instanceof Components.interfaces.nsIRDFResource )
			return node.Value;
		else if( node instanceof Components.interfaces.nsIRDFLiteral )
			return node.Value;

		return "";
	},

	getAll : function()
	{
		var lifemarks = new Array();
		// RDF variables
		var RDF = this.getRDF();
		var RDFC = this.getRDFC();
		var RDFCU = this.getRDFCU();
		var BMDS  = RDF.GetDataSource("rdf:bookmarks");
		var root = RDF.GetResource( "NC:BookmarksRoot" );
		var NameArc = RDF.GetResource( this.NC_NS + "Name" );
		var feedURLArc =  RDF.GetResource( this.NC_NS + "FeedURL" );
		var URLArc =  RDF.GetResource( this.NC_NS + "URL" );
		var typeArc = RDF.GetResource( this.RDF_NS + "type" );

		var nodesToProcess = new Array( root );
		var curNode, curType, curFeedURL, curName, enumerator;
		while( nodesToProcess.length > 0 )
		{
			curNode = nodesToProcess.pop();
			RDFC.Init( BMDS, curNode );
			enumerator = RDFC.GetElements();
			while( enumerator.hasMoreElements() )
			{
				curNode = enumerator.getNext();
				curType = this.getProperty( curNode, typeArc, BMDS ).split( "#" )[1];
				if( curType == "Folder" )
					nodesToProcess.push( curNode );
				else if( curType == "Livemark" )
				{
					curFeedURL = this.getProperty( curNode, feedURLArc, BMDS );
					curName = this.getProperty( curNode, NameArc, BMDS );
					lifemarks.push(new lifemarkData(curName, curFeedURL));
				}
			}
		}
		return lifemarks;
	},

  getAllUnique : function()
  {
    var livemarks = this.getAll();
    var uniqmarks = new Array();
    var isNew;
    if (livemarks.length > 0) uniqmarks.push(livemarks[0]);
    for (var i=1; i<livemarks.length; i++)
    {
      isNew = true;
      for (var j=0; j<uniqmarks.length; j++)
	if (uniqmarks[j].URL == livemarks[i].URL)
	{
	  isNew = false;
	  break;
	}
      if (isNew) uniqmarks.push(livemarks[i]);
    }
    return uniqmarks;
  }
}
