/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Ron Pruitt <wa84it@gmail.com>.
 * Portions created by the Initial Developer are Copyright (C) 2006-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var grp;
var feeds = new Array();
var titlelist = new Array();
var lists = new Array();
var isEmpty = false;
var addhere;

function goinit()
{
  var stringsBundle = document.getElementById("newsfox-string-bundle");
  addhere = stringsBundle.getString('addhere');
  grp = window.arguments[0].grp;
  titlelist = window.arguments[0].titlelist;
  lists = window.arguments[0].lists;
  feeds = window.arguments[0].feeds;
  var grpmovemenu = document.getElementById("grpmove");
  while (grpmovemenu.firstItem != null) 
	grpmovemenu.removeItem(grpmovemenu.firstItem);
  for (var i=1; i<titlelist.length; i++)
    if (i != grp)
      grpmovemenu.appendItem(entityDecode(titlelist[i]),i);
  var LASTname = stringsBundle.getString('LASTname');
  grpmovemenu.appendItem(LASTname,titlelist.length);
  grpmovemenu.selectedIndex = grp - 1;
  if (grp == 0)
  {
    grpmovemenu.value = 1;
    grpmovemenu.hidden = true;
    var grpmovespacer = document.getElementById("grpmovespacer");
    grpmovespacer.hidden = true;
    var grpmovelabel = document.getElementById("grpmovelabel");
    grpmovelabel.hidden = true;
    var grpfeeds = document.getElementById("group.feeds");
    grpfeeds.hidden = true;
    var grpfeedsspacer = document.getElementById("group.feedsspacer");
    grpfeedsspacer.hidden = true;
    var dragrtl = document.getElementById("dragrtl");
    dragrtl.hidden = true;
    var dragltr = document.getElementById("dragltr");
    dragltr.hidden = true;
  }
  document.getElementById("Name").value = entityDecode(titlelist[grp]);
  var grpTitle = stringsBundle.getString('grpName');
  var leftname = document.getElementById("feedsLeft");
  leftname.setAttribute("label",grpTitle + entityDecode(titlelist[grp]));
  var rightname = document.getElementById("feedsRight");
  rightname.setAttribute("label",grpTitle + entityDecode(titlelist[0]));
  var lefttree = document.getElementById("group.edit");
  lefttree.view = new GrpEditTreeModel(1);
  var righttree = document.getElementById("group.feeds");
  righttree.view = new GrpEditTreeModel(0);
}

function doAccept()
{
  window.arguments[0].ok = true;
  titlelist[grp] = document.getElementById("Name").value;
  window.arguments[0].newGrp = parseInt(document.getElementById("grpmove").value);
  if (lists[1][0] == -1) lists[1].splice(0,1);
  if (lists[0][0] == -1) lists[0].splice(0,1);
  window.arguments[0].titlelist = titlelist;
  window.arguments[0].lists = lists;
  return true;
}

function delFd(evt) { delRow(getRow(evt)); }

function delRow(row)
{
	lists[1].splice(row,1);
	lefttree = document.getElementById("group.edit");
	lefttree.view = new GrpEditTreeModel(1);
}

function addFd(evt) { addRow(1,lists[1].length,0,getRow(evt)); }

function addRow(newGrp, newrow, oldGrp, oldrow)
{
	if (isEmpty)
	{
		lists[newGrp].splice(0,1,lists[oldGrp][oldrow]);
		isEmpty = false;
	}
	else
	{
		var totdel = 0;
		var numdel = 0;  // should always be 1 or 0, but check
		var feedtoadd = lists[oldGrp][oldrow];
		var i=lists[newGrp].length;
		while (--i >= 0)
			if (feedtoadd == lists[newGrp][i])
			{
				totdel++;
				if (i < newrow) numdel++;
				lists[newGrp].splice(i,1);
			}
		lists[newGrp].splice(newrow-numdel,0,lists[oldGrp][oldrow]);
	}
//	this.treebox.rowCountChanged(newrow,1);
//	this.treebox.invalidate();
//	this.treebox.rowCountChanged(0,lists[newGrp].length);
//TODO	this.treebox.parentNode.view = new GrpEditTreeModel(newGrp);
	lefttree = document.getElementById("group.edit");
	lefttree.view = new GrpEditTreeModel(1);
}

function getRow(evt)
{
	var row = {}, col = {}, type = {};
	var tree = evt.target.parentNode;
	tree.treeBoxObject.getCellAt(evt.clientX, evt.clientY, row, col, type);
	return row.value;
}

var grpedtreeObserver = {
 
  onDragStart: function (evt,transferData,action){
		var row = {}, col = {}, type = {};
		var tree = evt.target.parentNode;
		tree.treeBoxObject.getCellAt(evt.clientX, evt.clientY, row, col, type); 
    transferData.data=new TransferData();
    var trdata = new Array();
    trdata.push(1*(tree.id == "group.edit"));
    trdata.push(row.value); 
    transferData.data.addDataForFlavour("grpedtreerow",trdata.join());
	},

	getSupportedFlavours : function () { 
		var flavours = new FlavourSet(); 
		flavours.appendFlavour("grpedtreerow"); 
		return flavours; 
	}, 

	onDragOver: function (evt,flavour,session){}, 

	onDrop: function (evt,dropdata,session){} 
};

////////////////////////////////////////////////////////////////
// EditorTreeModel
////////////////////////////////////////////////////////////////

function GrpEditTreeModel(index)
{
  if (lists[index].length == 0)
  {
    isEmpty = true;
    lists[index].push(-1);
  }
  this.rowCount = lists[index].length,
  this.getCellText = function(row,col)
  {
    if (lists[index][row] == -1) return addhere  
    else return entityDecode(feeds[lists[index][row]].getDisplayName()); 
  },
  this.getCellValue = function(row,col) {},
  this.getImageSrc = function(row,col)
  { 
    if (lists[index][row] == -1) return null
    else return feeds[lists[index][row]].icon.src; 
  },
  this.setTree = function(treebox){ this.treebox = treebox; },
  this.isContainer = function(row){ return false; },
  this.isSeparator = function(row){ return false; },
  this.isSorted = function(){ return false; },
  this.getLevel = function(row){ return 0; },
  this.cycleHeader = function(col){},
  this.getRowProperties = function(row,props){},
  this.getCellProperties = function(row,col,props)
  {
    var aserv = Components.classes["@mozilla.org/atom-service;1"].
      getService(Components.interfaces.nsIAtomService);
    props.AppendElement(aserv.getAtom("faviconcol"));
  },
  this.getColumnProperties = function(colid,col,props){},
  this.canDrop = function(evt,session) { return true; },
  this.getParentIndex = function(rowindex) { return -1; },
  this.drop = function(row,orientation)
  {
    var flavourSet = grpedtreeObserver.getSupportedFlavours();
    var transferData = nsTransferable.get(flavourSet, nsDragAndDrop.getDragData, true);
    var dropdata = transferData.first.first.data;
    var tmp = dropdata.split(",");
    var oldGrp = tmp[0];
    var oldrow = tmp[1];
    var newGrp = index;
    var newrow = row + (orientation == 1);
    if (oldGrp == newGrp)  // move position
    {
      var up = 1*(newrow > oldrow);
      tmp = lists[oldGrp].splice(oldrow,1);
      lists[oldGrp].splice(newrow-up,0,tmp);
      (up == 1) ? this.treebox.invalidateRange(oldrow,newrow)
		: this.treebox.invalidateRange(newrow,oldrow);
    }
    else if (newGrp == 0)  // delete from group
			delRow(oldrow);
    else // oldGrp == 0, add to group
			addRow(newGrp, newrow, oldGrp, oldrow);
  } 
}
