/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Profile
////////////////////////////////////////////////////////////////

/**
 * Get the newsfox directory under the user profile
 * directory.  Create newsfox directory if it does
 * not exist. 
 */
function getProfileDir()
{
  var file = Components.classes["@mozilla.org/file/directory_service;1"].
    getService(Components.interfaces.nsIProperties).
    get("ProfD", Components.interfaces.nsIFile);
  file.append("newsfox");
  if (!file.exists()) file.create(0x01, 0750);
  return file;
}

function getTextView(art)
{
	var iframe = document.getElementById("buildContent");
	var doc = iframe.contentDocument;
	iframe.docShell.allowJavascript = false;

	while (doc.body.childNodes.length > 0) doc.body.removeChild(doc.body.childNodes[0]);

  var div = doc.createElement("div");
	div.setAttribute("id","newsfox-box");
  var b = doc.createElement("b");
	b.innerHTML = emphsrch(art.title);
	div.appendChild(b);
	div.appendChild(doc.createElement("br"));
	var p = doc.createElement("span");
	p.innerHTML = "";
  if (art.category != "") p.innerHTML += emphsrch(art.category) + ": ";
	p.innerHTML += art.date.toLocaleString();
	div.appendChild(p);
	div.appendChild(doc.createElement("br"));
  var a = doc.createElement("a");
	a.setAttribute("href", art.link);
	a.innerHTML = art.link;
	div.appendChild(a);

  var p = doc.createElement("p");
  p.innerHTML = emphsrch(art.body);

	doc.body.appendChild(div);
	doc.body.appendChild(p);
}

function emphsrch(html)
{
	return html;
}

function getCss()
{
	var file = getProfileDir();
	file.append("textview.css");
  var inputStream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance( Components.interfaces.nsIFileInputStream );
  inputStream.init( file,0x01,00004,null);
  var scInputStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance( Components.interfaces.nsIScriptableInputStream );
  scInputStream.init(inputStream);
  var output = scInputStream.read(-1);
  scInputStream.close();
  inputStream.close();
	return output;
}

function makeCss()
{
	var file, out;
	file = getProfileDir();
	file.append("textview.css");
	if (!file.exists())
	{
		out = openOutputStream(file, 0x02 | 0x08 | 0x20);
		println(out, "body { font:10pt Verdana,sans-serif; background:white; }\n");
		println(out, "#newsfox-box { background: #e3dfd9; padding:10px; overflow:hidden; }\n");
		out.close();
	}
}

function resetIframe()
{
	var iframe = document.getElementById("buildContent");
	var doc = iframe.contentDocument;

// doesn't work, need to keep node with name='html' if it exists
//	while (doc.childNodes.length > 0) doc.removeChild(doc.childNodes[0]);

	var docHEAD = null;
	for (var i=0; i<doc.childNodes.length; i++)
		if (doc.childNodes[i].localName == "HTML")
		{
			var docHTML = doc.childNodes[i];
			for (i=0; i<docHTML.childNodes.length; i++)
				if (docHTML.childNodes[i].localName == "HEAD")
				{
					docHEAD = docHTML.childNodes[i];
					while (docHEAD.childNodes.length > 0)
						docHEAD.removeChild(docHEAD.childNodes[0]);
				}
				else if (docHTML.childNodes[i].localName == "BODY")
				{
					var docBODY = docHTML.childNodes[i];
					while (docBODY.childNodes.length > 0)
						docBODY.removeChild(docBODY.childNodes[0]);
				}
				else
					docHTML.removeChild(docHTML.childNodes[i]);
		}

	var meta = doc.createElement("meta");
	meta.setAttribute("http-equiv", "content-type");
	meta.setAttribute("content", "text/html");
	meta.setAttribute("charset", "utf-8");

	var sty = doc.createElement("style");
	sty.setAttribute("type","text/css");
	sty.innerHTML = getCss();

	docHEAD.appendChild(meta);
	docHEAD.appendChild(sty);
}

////////////////////////////////////////////////////////////////
// File Util
////////////////////////////////////////////////////////////////

function openOutputStream(file, flags)
{
  var out = Components.classes["@mozilla.org/network/file-output-stream;1"]
    .createInstance(Components.interfaces.nsIFileOutputStream);
  out.init(file, flags, 0664, 0);
  return out;
}

function print(out, data)
{
  out.write(data, data.length);
}

function println(out, data)
{
  data += "\n";
  out.write(data, data.length);
}

////////////////////////////////////////////////////////////////
// Create new feed
////////////////////////////////////////////////////////////////

function createNewFeed(model, url, isExcluded, rmArtfile)
{
	var feed;
  try
  {
    var uid  = model.makeUniqueUid(url); //makeUid(model, url);
    feed = new Feed();
    feed.uid = uid;
    feed.url = url;
    feed.defaultName = uid;
    feed.exclude = isExcluded;
    model.add(feed, isExcluded);
		if (rmArtfile) deleteFeedFromDisk(feed);
    if (!isExcluded)
      {
        var feedtree = document.getElementById("newsfox.feedTree");
        if (feedGroup[0].expanded == true) feedtree.view.toggleOpenState(0);
        var index = model.size();
        feedGroup[0].list.push(index-1);
        feedtree.view.toggleOpenState(0);
      }
  }
  catch (err) 
  { 
    var msg = "createNewFeed(): [" + uid + "] " + err
    alert(msg); 
  }
  return feed; 
}

////////////////////////////////////////////////////////////////
// Load feeds from disk
////////////////////////////////////////////////////////////////

function loadIndices()
// globals: fdgpidx, feedidx, catgidx, openidx
{
  try
  {
    var file = getProfileDir();
    file.append("master_index.xml");

    var xml = document.implementation.createDocument("","",null);
    xml.async = false;
    xml.load("file:///" + file.path);

    // Get file version
    var root = xml.getElementsByTagName("newsfox-index")[0];
    var version = root.getAttribute("version");

    var fdgpidxstr = xml.getElementsByTagName("fdgpidx")[0].childNodes[0].nodeValue;
    var tmp = fdgpidxstr.split(",");
    for (var i=0; i < tmp.length; i++)
      tmp[i] = parseInt(tmp[i]);
    fdgpidx = tmp;

    var feedidxstr = xml.getElementsByTagName("feedidx")[0].childNodes[0].nodeValue;
    tmp = feedidxstr.split(",");
    for (i=0; i < tmp.length; i++)
      tmp[i] = parseInt(tmp[i]);
    feedidx = tmp;

    var catgidxstr = xml.getElementsByTagName("catgidx")[0].childNodes[0].nodeValue;
    tmp = catgidxstr.split(",");
    for (i=0; i < tmp.length; i++)
    {
      tmp[i] = parseInt(tmp[i]);
      if (tmp[i] > 0) 
      {
	var feed = model.get(feedidx[i]);
	loadFeed(feed);
      }
    }
    catgidx = tmp;

    var openidxstr = xml.getElementsByTagName("openidx")[0].childNodes[0].nodeValue;
    tmp = openidxstr.split(",");
    for (i=0; i < tmp.length; i++)
      tmp[i] = (tmp[i] == 1);
    openidx = tmp;
  }
  catch (err) { alert("loadIndices(): " + err); }
}

function loadGroupModel()
{
  try
  {
    var file = getProfileDir();
    file.append("master_group.xml");

    var xml = document.implementation.createDocument("","",null);
    xml.async = false;
    xml.load("file:///" + file.path);

    // Get file version
    var root = xml.getElementsByTagName("newsfox-grouplist")[0];
    var version = root.getAttribute("version");

    var tmp = new Array();
    var kids = xml.getElementsByTagName("group");
    for (var i=0; i<kids.length; i++)
    {
      feedGroup[i] = new FeedGroup();
//check empty string
      feedGroup[i].title = child(kids[i], "title").childNodes[0].nodeValue;
      feedGroup[i].expanded = child(kids[i], "expanded").childNodes[0].nodeValue;
      feedGroup[i].expanded = (feedGroup[i].expanded == "true");
      var v = child(kids[i], "list");
      if (v != null && v.childNodes.length > 0)
      {
	var tmpstr = v.childNodes[0].nodeValue;
	var tmp = tmpstr.split(",");
	for (var j=0; j < tmp.length; j++)
	  feedGroup[i].list[j] = parseInt(tmp[j]);
      }
    feedGroup.length = kids.length;
    }
  }
  catch (err) { alert("loadGroupModel(): " + err); }
}

function loadFeedModel()
{
  model = new Model();
  try
  {
    var file = getProfileDir();
    file.append("master.xml");

    var xml = document.implementation.createDocument("","",null);
    xml.async = false;
    xml.load("file:///" + file.path);

    // Get file version
    var root = xml.getElementsByTagName("newsfox-feedlist")[0];
    var version = root.getAttribute("version");

		var iconfile, leafName;
    var kids = xml.getElementsByTagName("feed");
    for (var i=0; i<kids.length; i++)
    {
      var feed = new Feed();
			feed.exclude = (kids[i].getAttribute("exclude") == "true");
      feed.uid = child(kids[i], "uid").childNodes[0].nodeValue;
      feed.url = child(kids[i], "url").childNodes[0].nodeValue;
      feed.defaultName = feed.uid; 
      var v = child(kids[i], "dname");
      if (v != null) feed.defaultName = v.childNodes[0].nodeValue;

      v = child(kids[i], "home");
      if (v != null && v.childNodes.length > 0) feed.homepage = v.childNodes[0].nodeValue;

			iconfile = getProfileDir();
			leafName = feed.uid + ".ico";
			iconfile.append(leafName);
			if (!options.favicons  || !iconfile.exists() || !isImg(iconfile))
				feed.icon.src = iconOk;
			else
				feed.icon.src = "file:///" + iconfile.path;

      v = child(kids[i], "style");
      if (v != null && v.childNodes.length > 0) feed.style = parseInt(v.childNodes[0].nodeValue);

      v = child(kids[i], "deleteOld");
      if (v != null && v.childNodes.length > 0) 
        feed.deleteOld = (v.childNodes[0].nodeValue == "true");

      v = child(kids[i], "autoCheck");
      if (v != null && v.childNodes.length > 0)
        feed.autoCheck = (v.childNodes[0].nodeValue == "true");
      else feed.autoCheck = true;

      v = child(kids[i], "customName");
      if (v != null && v.childNodes.length > 0) feed.customName = v.childNodes[0].nodeValue;

      v = child(kids[i], "dontDeleteUnread");
      if (v != null && v.childNodes.length > 0) feed.dontDeleteUnread = (v.childNodes[0].nodeValue == "true");

      var elem = child(kids[i], "flags");
      if (elem != null && elem.childNodes.length > 0)
      {
        var flags = elem.childNodes[0].nodeValue;
        for (var j=0; j<flags.length; j++)
          feed.flags.push(parseInt(flags.charAt(j)));
      }

      // Version 1.0 tried to encode body text. Version 1.1
      // just uses CDATA, so decode not necessary
      if (version == "1.0")
      {
        feed.url = decodeHTML(feed.url);
        feed.defaultName = decodeHTML(feed.defaultName);
        feed.homepage = decodeHTML(feed.homepage);
      }

      model.add(feed);
    }
  }
  catch (err) 
  { 
    var msg = "loadFeedModel(): " + "[" + feed.uid + "," + elem + "]\n" + err; 
    alert(msg);
  }
}

function loadFeed(feed)
{
	if (feed.loaded) return;
  try
  {
    var file = getProfileDir();
    file.append(feed.uid + ".xml");
    checkFeedFile(file);

    var xml = document.implementation.createDocument("","",null);
    xml.async = false;
    xml.load("file:///" + file.path);

    // Get file version
    var root = xml.getElementsByTagName("newsfox-feed")[0];
    var version = root.getAttribute("version");

    var kids = xml.getElementsByTagName("article");
    for (var i=0; i<kids.length; i++)
    {
      var link  = child(kids[i], "link").childNodes[0];
      var title = child(kids[i], "title").childNodes[0];
      var date  = child(kids[i], "date").childNodes[0];
      var body  = child(kids[i], "body").childNodes[0];

      // AG: added category
      var category  = child(kids[i], "category");
      if (category != null) category = category.childNodes[0];

      var art = new Article();
      art.link  = (link  == null) ? "" : link.nodeValue;
      art.title = (title == null) ? "" : title.nodeValue;
      art.body  = (body  == null) ? "" : body.nodeValue;
      art.date  = new Date();
      if (date != null) art.date.setTime(Date.parse(date.nodeValue));
      // AG: added category
      art.category  = (category  == null) ? "" : category.nodeValue;

      // Version 1.0 tried to encode body text. Version 1.1
      // just uses CDATA, so decode not necessary
      if (version == "1.0")
      {
        art.link  = decodeHTML(art.link);
        art.title = decodeHTML(art.title);
        art.body  = decodeHTML(art.body);
      }

      // Add feed
      feed.addExisting(art);
    }
    feed.sortCategories();

		// load deleted articles
    var kids = xml.getElementsByTagName("deletedarticle");
    for (var i=0; i<kids.length; i++)
    {
      var link  = child(kids[i], "link").childNodes[0];
      var date  = child(kids[i], "date").childNodes[0];

      var art = new Article();
      art.link  = (link  == null) ? "" : link.nodeValue;
      art.date  = new Date();
      if (date != null) art.date.setTime(Date.parse(date.nodeValue));

      feed.deletedaddExisting(art);
    }

		feed.loaded = true;
  }
  catch (err) { alert("loadFeed(): " + feed.uid + "\n" + err); }
}

function checkFeedFile(file)
{
  try
  {
    if (!file.exists())
    {
      var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
      println(out, "<newsfox-feed version=\"1.1\">");
      println(out, "</newsfox-feed>");
      out.close();
    }
  }
  catch (err) { alert(err); }
}


////////////////////////////////////////////////////////////////
// Save feeds to disk
////////////////////////////////////////////////////////////////

function saveIndices()
{
  try
  {
    var file = getProfileDir();
    file.append("master_index.xml");

    var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
    println(out, "<newsfox-index version=\"1.0\">");
    var fdgpidxstr = fdgpidx.join();
    println(out, "  <fdgpidx>" + fdgpidxstr + "</fdgpidx>");
    var feedidxstr = feedidx.join();
    println(out, "  <feedidx>" + feedidxstr + "</feedidx>");
    var catgidxstr = catgidx.join();
    println(out, "  <catgidx>" + catgidxstr + "</catgidx>");
    var tmp = new Array();
    for (var i=0; i<openidx.length; i++)
      tmp[i] = 1*(openidx[i] == true);
    var openidxstr = tmp.join();
    println(out, "  <openidx>" + openidxstr + "</openidx>");
    println(out, "</newsfox-index>");
    out.close();
  }
  catch (err) { alert("saveIndices(): " + err); }
}

function saveGroupModel()
{
  try
  {
    var file = getProfileDir();
    file.append("master_group.xml");

    var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
    println(out, "<newsfox-grouplist version=\"1.0\">");
    for (var i=0; i<feedGroup.length; i++)
    {
      var grpstr = feedGroup[i].list.join();
      println(out, " <group>");
      println(out, "  <title><![CDATA[" + feedGroup[i].title + "]]></title>");
      println(out, "  <expanded>" + feedGroup[i].expanded + "</expanded>");
      println(out, "  <list>" + grpstr + "</list>");
      println(out, " </group>");
    }
    println(out, "</newsfox-grouplist>");
    out.close();
  }
  catch (err) { alert("saveGroupModel(): " + err); }
}

function saveFeedModel()
{
  try
  {
    var file = getProfileDir();
    file.append("master.xml");

    var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
    println(out, "<newsfox-feedlist version=\"1.2\">");
    for (var i=0; i<model.sizeTotal(); i++)
    {
      var feed = model.get(i);
      println(out, " <feed exclude=\"" + feed.exclude + "\">");
      println(out, "  <uid>" + feed.uid + "</uid>");
      println(out, "  <url><![CDATA[" + feed.url + "]]></url>");
      println(out, "  <dname><![CDATA[" + feed.defaultName + "]]></dname>");
      if (feed.homepage != null)
        println(out, "  <home><![CDATA[" + feed.homepage + "]]></home>");
			// Only save if property overrides global setting
      if (feed.style != 0)
        println(out, "  <style>" + feed.style + "</style>");
      println(out, "  <deleteOld>" + feed.deleteOld + "</deleteOld>");
      println(out, "  <autoCheck>" + feed.autoCheck + "</autoCheck>");
			if( null != feed.customName )
	      println(out, "  <customName><![CDATA[" + feed.customName + "]]></customName>");
      println(out, "  <dontDeleteUnread>" + feed.dontDeleteUnread + "</dontDeleteUnread>");
      print(out, "  <flags>");
			var fdflag;
      for (var j=0; j<feed.flags.length; j++)
			{
				fdflag = 1*((feed.flags[j] & 0x01)!=0) + 4*((feed.flags[j] & 0x04)!=0);
//RPdebug				if (fdflag != feed.flags[j]) alert(feed.getDisplayName() + "  j= " + j + "  feed.flags[j]= " + feed.flags[j]);
        print(out, "" + fdflag);
			}
      println(out, "</flags>");
      println(out, " </feed>");
    }
    println(out, "</newsfox-feedlist>");
    out.close();
  }
  catch (err) { alert("saveFeedModel(): [" + feed.uid + "] " + err); }
}

function saveFeed(feed)
{
  var file = getProfileDir();
  file.append(feed.uid + ".xml");

  var out = openOutputStream(file, 0x02 | 0x08 | 0x20);
  println(out, "<newsfox-feed version=\"1.2\">");
  for (var i=0; i<feed.size(); i++)
  {
    var art = feed.get(i);
    println(out, " <article>");
    println(out, "  <link><![CDATA[" + art.link + "]]></link>");
    println(out, "  <title><![CDATA[" + art.title + "]]></title>");
    println(out, "  <date>" + art.date + "</date>");
    println(out, "  <body><![CDATA[" + art.body + "]]></body>");
    // AG: added category
    println(out, "  <category><![CDATA[" + art.category + "]]></category>");
    println(out, " </article>");
  }
  for (var i=0; i<feed.deletedsize(); i++)
  {
    var art = feed.deletedget(i);
    println(out, " <deletedarticle>");
    println(out, "  <link><![CDATA[" + art.link + "]]></link>");
    println(out, "  <date>" + art.date + "</date>");
    println(out, " </deletedarticle>");
  }
  println(out, "</newsfox-feed>");
  out.close();
}

////////////////////////////////////////////////////////////////
// Delete feed
////////////////////////////////////////////////////////////////

function deleteFeedFromDisk(feed)
{
  try
  {
    var file = getProfileDir();
    file.append(feed.uid + ".xml");
    if (file.exists()) file.remove(false);
    var file = getProfileDir();
    file.append(feed.uid + ".ico");
    if (file.exists()) file.remove(false);
  }
  catch (err) {} // TODO sometimes icon file locked, file now checked on creation as well - alert("deleteFeedFromDisk(): [" + feed.uid + "] " + err); }
}

////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////

function child(element, tagName)
{
  var kids = element.childNodes;
  for (var i=0; i<kids.length; i++)
    if (kids[i].nodeName == tagName) 
      return kids[i];
  return null;
}

////////////////////////////////////////////////////////////////
// Encode/Decode
////////////////////////////////////////////////////////////////

/**
 * Return XML-friendly HTML encoding.
 */
function encodeHTML(s) 
{
  s = s.replace(new RegExp('&','gi'), '&amp;');
  s = s.replace(new RegExp('<','gi'), '&lt;');
  s = s.replace(new RegExp('>','gi'), '&gt;');
  s = s.replace(new RegExp('"','gi'), '&quot;');
  return s;
}

/**
 * Return original HTML from encoding.
 */
function decodeHTML(s)
{
  s = s.replace(new RegExp('&amp;'  ,'gi'), '&');
  s = s.replace(new RegExp('&lt;'   ,'gi'), '<');
  s = s.replace(new RegExp('&gt;'   ,'gi'), '>');
  s = s.replace(new RegExp('&quot;' ,'gi'), '"');
  s = s.replace(new RegExp('&acute;','gi'), '');
  return s;
}
