/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Error Codes
////////////////////////////////////////////////////////////////

var ERROR_OK = 0;
var ERROR_INVALID_FEED_URL = 1;
var ERROR_UNKNOWN_FEED_FORMAT = 2;

/**
 * Get a human readable summary of error.
 */
function getErrorSummary(code)
{
  switch (code)
  {
    case ERROR_OK: 
      return "This feed is functioning properly";
    case ERROR_INVALID_FEED_URL:
      return "Invalid feed URL";
    case ERROR_UNKNOWN_FEED_FORMAT:
      return "Unknown feed format";
    default: return "Parse Error";
  }
} 

/**
 * Get possible remedies for this error.
 */
function getErrorRemedies(code)
{
  // TODO - break out into HTML referenced by ID
  switch (code)
  {
    case ERROR_OK: return "";
    case ERROR_INVALID_FEED_URL:
      return "The feed url is invalid.  Check to make sure the URL is correct.";
    case ERROR_UNKNOWN_FEED_FORMAT:
      return "NewsFox does not recognize this feed format. NewsFox "+
        "supports RSS 0.91,0.92,2.0, and Atom 0.3,1.0.  If this feed uses " +
        "one of those formats then email me a bug report.  Be sure to " + 
        "include the feed url and this error code.";        
    default: return code;
  }
}
